<?php
/* --------------------------------------------------------------
   RequestTokenController.inc.php 2018-07-26
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

namespace Extensions\AdminFeed\ShopInfo\Shop\Classes;

use ContentViewInterface;
use Extensions\AdminFeed\CurlClient;
use Extensions\AdminFeed\RequestControl;
use HttpContextReaderInterface;
use HttpControllerResponse;
use HttpResponseProcessorInterface;
use HttpViewController;

/**
 * Class ShopInfoController
 */
final class RequestTokenController extends HttpViewController
{

    /**
     * @var RequestControl
     */
    private $requestControl;


    public function __construct(
        HttpContextReaderInterface     $httpContextReader,
        HttpResponseProcessorInterface $httpResponseProcessor,
        ContentViewInterface           $defaultContentView
    )
    {
        parent::__construct($httpContextReader, $httpResponseProcessor, $defaultContentView);
        $this->requestControl = new RequestControl(new CurlClient());
    }


    public function actionDefault()
    {
        $jsonOption = $this->_getQueryParameter('pretty') !== null ? JSON_PRETTY_PRINT : 0;
        $httpHeader = ['Content-Type: text/json; charset=utf-8'];
        $response = json_encode($this->requestControl->createRequestToken(), $jsonOption);

        return new HttpControllerResponse($response, $httpHeader);
    }
}